/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math.util.ResizableDoubleArray;

public class DescriptiveStatisticsImpl
extends DescriptiveStatistics
implements Serializable {
    static final long serialVersionUID = -1868088725461221010L;
    protected int windowSize;
    protected ResizableDoubleArray eDA = new ResizableDoubleArray();

    public DescriptiveStatisticsImpl() {
        this(-1);
    }

    public DescriptiveStatisticsImpl(int window) {
        this.setWindowSize(window);
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public double[] getValues() {
        double[] copiedArray = new double[this.eDA.getNumElements()];
        System.arraycopy(this.eDA.getElements(), 0, copiedArray, 0, this.eDA.getNumElements());
        return copiedArray;
    }

    public double getElement(int index) {
        return this.eDA.getElement(index);
    }

    public long getN() {
        return this.eDA.getNumElements();
    }

    public void addValue(double v) {
        if (this.windowSize != -1) {
            if (this.getN() == (long)this.windowSize) {
                this.eDA.addElementRolling(v);
            } else if (this.getN() < (long)this.windowSize) {
                this.eDA.addElement(v);
            }
        } else {
            this.eDA.addElement(v);
        }
    }

    public void clear() {
        this.eDA.clear();
    }

    public void setWindowSize(int windowSize) {
        if (windowSize < 1 && windowSize != -1) {
            throw new IllegalArgumentException("window size must be positive.");
        }
        this.windowSize = windowSize;
        if (windowSize != -1 && windowSize < this.eDA.getNumElements()) {
            this.eDA.discardFrontElements(this.eDA.getNumElements() - windowSize);
        }
    }

    public double apply(UnivariateStatistic stat) {
        return stat.evaluate(this.eDA.getValues(), this.eDA.start(), this.eDA.getNumElements());
    }
}

