import { Connection, TextDocumentIdentifier, Diagnostic, CancellationToken } from 'vscode-languageserver';
import { DocumentManager, Document } from './documents';
export type SendDiagnostics = Connection['sendDiagnostics'];
export type GetDiagnostics = (doc: TextDocumentIdentifier, cancellationToken?: CancellationToken) => Thenable<Diagnostic[]>;
export declare class DiagnosticsManager {
    private sendDiagnostics;
    private docManager;
    private getDiagnostics;
    constructor(sendDiagnostics: SendDiagnostics, docManager: DocumentManager, getDiagnostics: GetDiagnostics);
    private pendingUpdates;
    private cancellationTokens;
    private updateAll;
    scheduleUpdateAll(): void;
    private debouncedUpdateAll;
    private update;
    cancelStarted(uri: string): void;
    removeDiagnostics(document: Document): void;
    scheduleUpdate(document: Document): void;
    private scheduleBatchUpdate;
}
