/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WithNamespace
extends AbstractNamespace {
    private final SqlWith with;

    WithNamespace(SqlValidatorImpl validator, SqlWith with, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.with = with;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        for (SqlNode withItem : this.with.withList) {
            this.validator.validateWithItem((SqlWithItem)withItem);
        }
        SqlValidatorScope scope2 = this.validator.getWithScope(Util.last(this.with.withList));
        SqlValidatorNamespace bodyNamespace = Objects.requireNonNull(this.validator.getNamespace(this.with.body), "namespace");
        this.validator.validateQuery(this.with.body, scope2, targetRowType);
        RelDataType rowType = this.validator.getValidatedNodeType(this.with.body);
        this.validator.setValidatedNodeType(this.with, rowType);
        this.filterRequirement = bodyNamespace.getFilterRequirement();
        return rowType;
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.with;
    }
}

