/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.quantizer;

import java.util.Random;
import lombok.Generated;
import org.apache.lucene.util.VectorUtil;

public final class RandomGaussianRotation {
    public static float[][] generateRotationMatrix(int dimensions) {
        int i;
        Random random = new Random(1212121212L);
        float[][] rotationMatrix = new float[dimensions][dimensions];
        for (i = 0; i < dimensions; ++i) {
            for (int j = 0; j < dimensions; ++j) {
                rotationMatrix[i][j] = (float)random.nextGaussian();
            }
        }
        for (i = 0; i < dimensions; ++i) {
            float norm = VectorUtil.dotProduct((float[])rotationMatrix[i], (float[])rotationMatrix[i]);
            norm = (float)Math.sqrt(norm);
            int j = 0;
            while (j < dimensions) {
                float[] fArray = rotationMatrix[i];
                int n = j++;
                fArray[n] = fArray[n] / norm;
            }
            for (int k = 0; k < i; ++k) {
                int j2;
                float dotProduct = 0.0f;
                for (j2 = 0; j2 < dimensions; ++j2) {
                    dotProduct += rotationMatrix[i][j2] * rotationMatrix[k][j2];
                }
                for (j2 = 0; j2 < dimensions; ++j2) {
                    float[] fArray = rotationMatrix[i];
                    int n = j2;
                    fArray[n] = fArray[n] - dotProduct * rotationMatrix[k][j2];
                }
            }
            norm = 0.0f;
            for (j = 0; j < dimensions; ++j) {
                norm += rotationMatrix[i][j] * rotationMatrix[i][j];
            }
            norm = (float)Math.sqrt(norm);
            j = 0;
            while (j < dimensions) {
                float[] fArray = rotationMatrix[i];
                int n = j++;
                fArray[n] = fArray[n] / norm;
            }
        }
        return rotationMatrix;
    }

    public static float[] applyRotation(float[] vector, float[][] rotationMatrix) {
        int dimensions = vector.length;
        float[] rotatedVector = new float[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            rotatedVector[i] = VectorUtil.dotProduct((float[])rotationMatrix[i], (float[])vector);
        }
        return rotatedVector;
    }

    @Generated
    private RandomGaussianRotation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

