"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setNavBreadCrumbs = void 0;
var _core_refs = require("../../public/framework/core_refs");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const setNavBreadCrumbs = (parentBreadCrumb, pageBreadCrumb, counter) => {
  var _coreRefs$chrome;
  const isNavGroupEnabled = _core_refs.coreRefs === null || _core_refs.coreRefs === void 0 || (_coreRefs$chrome = _core_refs.coreRefs.chrome) === null || _coreRefs$chrome === void 0 ? void 0 : _coreRefs$chrome.navGroup.getNavGroupEnabled();
  const updatedPageBreadCrumb = pageBreadCrumb.map(crumb => ({
    ...crumb,
    text: isNavGroupEnabled && counter !== undefined ? `${crumb.text} (${counter})` : crumb.text
  }));
  if (isNavGroupEnabled) {
    var _coreRefs$chrome2;
    _core_refs.coreRefs === null || _core_refs.coreRefs === void 0 || (_coreRefs$chrome2 = _core_refs.coreRefs.chrome) === null || _coreRefs$chrome2 === void 0 || _coreRefs$chrome2.setBreadcrumbs([...updatedPageBreadCrumb]);
  } else {
    var _coreRefs$chrome3;
    _core_refs.coreRefs === null || _core_refs.coreRefs === void 0 || (_coreRefs$chrome3 = _core_refs.coreRefs.chrome) === null || _coreRefs$chrome3 === void 0 || _coreRefs$chrome3.setBreadcrumbs([...parentBreadCrumb, ...updatedPageBreadCrumb]);
  }
};
exports.setNavBreadCrumbs = setNavBreadCrumbs;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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