/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class StoreStats
implements Writeable,
ToXContentFragment {
    public static final long UNKNOWN_RESERVED_BYTES = -1L;
    private long sizeInBytes;
    private long reservedSize;

    public StoreStats() {
    }

    private StoreStats(Builder builder) {
        this.sizeInBytes = builder.sizeInBytes;
        this.reservedSize = builder.reservedSize;
    }

    public StoreStats(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        this.reservedSize = in.readZLong();
    }

    @Deprecated
    public StoreStats(long sizeInBytes, long reservedSize) {
        assert (reservedSize == -1L || reservedSize >= 0L) : reservedSize;
        this.sizeInBytes = sizeInBytes;
        this.reservedSize = reservedSize;
    }

    public void add(StoreStats stats) {
        if (stats == null) {
            return;
        }
        this.sizeInBytes += stats.sizeInBytes;
        this.reservedSize = StoreStats.ignoreIfUnknown(this.reservedSize) + StoreStats.ignoreIfUnknown(stats.reservedSize);
    }

    private static long ignoreIfUnknown(long reservedSize) {
        return reservedSize == -1L ? 0L : reservedSize;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue size() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ByteSizeValue getSize() {
        return this.size();
    }

    public ByteSizeValue getReservedSize() {
        return new ByteSizeValue(this.reservedSize);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        out.writeZLong(this.reservedSize);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("store");
        builder.humanReadableField("size_in_bytes", "size", (Object)this.size());
        builder.humanReadableField("reserved_in_bytes", "reserved", (Object)this.getReservedSize());
        builder.endObject();
        return builder;
    }

    public static class Builder {
        private long sizeInBytes = 0L;
        private long reservedSize = 0L;

        public Builder sizeInBytes(long bytes) {
            this.sizeInBytes = bytes;
            return this;
        }

        public Builder reservedSize(long size) {
            assert (size == -1L || size >= 0L) : size;
            this.reservedSize = size;
            return this;
        }

        public StoreStats build() {
            return new StoreStats(this);
        }
    }

    static final class Fields {
        static final String STORE = "store";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String RESERVED = "reserved";
        static final String RESERVED_IN_BYTES = "reserved_in_bytes";

        Fields() {
        }
    }
}

