/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.HAManager;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.FanUpEventListener;
import oracle.simplefan.LoadAdvisoryEvent;
import oracle.simplefan.NodeDownEvent;
import oracle.simplefan.NodeUpEvent;
import oracle.simplefan.ServiceDownEvent;
import oracle.simplefan.ServiceUpEvent;

final class HAFanListener
implements FanEventListener,
FanUpEventListener,
Diagnosable {
    private static final String CLASS_NAME = HAFanListener.class.getName();
    HAManager haManager = null;

    HAFanListener(HAManager haManager) {
        this.haManager = haManager;
    }

    public void handleEvent(ServiceDownEvent event) {
        String evtService = HAFanListener.toLowerCase(event.getServiceName());
        String evtDbUnique = HAFanListener.toLowerCase(event.getDatabaseUniqueName());
        String evtInstance = null;
        String evtHost = null;
        int drainTimeout = event.getDrainTimeout();
        block0 : switch (event.getKind()) {
            case MEMBER: {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleEvent", "========= FAN down, event type=MEMBER. ", null, null);
                evtInstance = HAFanListener.toLowerCase(event.getServiceMemberEvent().getInstanceName());
                evtHost = HAFanListener.toLowerCase(event.getServiceMemberEvent().getNodeName());
            }
            case COMPOSITE: {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleEvent", "========= FAN down, event type=COMPOSITE. ", null, null);
                switch (event.getReason()) {
                    case USER: {
                        this.haManager.plannedDown(evtService, evtInstance, evtDbUnique, evtHost, drainTimeout);
                        break block0;
                    }
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleEvent", "========= FAN down, event type=default. ", null, null);
                this.haManager.unplannedDown(evtService, evtInstance, evtDbUnique, evtHost);
                break;
            }
        }
    }

    public void handleEvent(ServiceUpEvent event) {
        String evtService = HAFanListener.toLowerCase(event.getServiceName());
        String evtDbUnique = HAFanListener.toLowerCase(event.getDatabaseUniqueName());
        String evtInstance = null;
        String evtHost = null;
        int cardinality = event.getCardinality();
        switch (event.getKind()) {
            case MEMBER: {
                evtInstance = HAFanListener.toLowerCase(event.getServiceMemberEvent().getInstanceName());
                evtHost = HAFanListener.toLowerCase(event.getServiceMemberEvent().getNodeName());
            }
            case COMPOSITE: {
                this.haManager.serviceUp(evtService, evtInstance, evtDbUnique, evtHost, cardinality);
                break;
            }
        }
    }

    public void handleEvent(NodeDownEvent event) {
        String evtHost = event.getNodeName();
        this.haManager.nodeDown(evtHost);
    }

    public void handleEvent(LoadAdvisoryEvent event) {
    }

    public void handleEvent(NodeUpEvent event) {
    }

    private static String toLowerCase(String s) {
        return null == s ? null : s.toLowerCase();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

