/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.impl;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.client.clienttype.ClientTypeProvider;
import org.keycloak.representations.idm.ClientTypeRepresentation;
import org.keycloak.services.clienttype.impl.DefaultClientType;

public class DefaultClientTypeProvider
implements ClientTypeProvider {
    private static final Logger logger = Logger.getLogger(DefaultClientTypeProvider.class);

    public ClientType getClientType(ClientTypeRepresentation clientTypeRep, ClientType parent) {
        return new DefaultClientType(clientTypeRep, parent);
    }

    public ClientTypeRepresentation checkClientTypeConfig(ClientTypeRepresentation clientType) throws ClientTypeException {
        Map config = clientType.getConfig();
        for (Map.Entry entry : config.entrySet()) {
            String propertyName = (String)entry.getKey();
            ClientTypeRepresentation.PropertyConfig propConfig = (ClientTypeRepresentation.PropertyConfig)entry.getValue();
            if (propConfig.getApplicable() == null) {
                logger.errorf("Property '%s' does not have 'applicable' configured for client type '%s'", (Object)propertyName, (Object)clientType.getName());
                throw ClientTypeException.Message.CLIENT_TYPE_FIELD_NOT_APPLICABLE.exception(new Object[0]);
            }
            if (propConfig.getApplicable().booleanValue() || propConfig.getValue() == null) continue;
            logger.errorf("Property '%s' is not applicable and so should not have read-only or default-value set for client type '%s'", (Object)propertyName, (Object)clientType.getName());
            throw ClientTypeException.Message.INVALID_CLIENT_TYPE_CONFIGURATION.exception(new Object[0]);
        }
        return clientType;
    }
}

