/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.PropagatingFromUpstreamInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.PropagatingToDownstreamInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressionStrategy;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressors;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.instrumentation.api.internal.InstrumenterBuilderAccess;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.SchemaUrlProvider;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class InstrumenterBuilder<REQUEST, RESPONSE> {
    private static final Logger logger = Logger.getLogger(InstrumenterBuilder.class.getName());
    private static final SpanSuppressionStrategy spanSuppressionStrategy = SpanSuppressionStrategy.fromConfig(ConfigPropertiesUtil.getString("otel.instrumentation.experimental.span-suppression-strategy"));
    final OpenTelemetry openTelemetry;
    final String instrumentationName;
    final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    final List<SpanLinksExtractor<? super REQUEST>> spanLinksExtractors = new ArrayList<SpanLinksExtractor<? super REQUEST>>();
    final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    final List<ContextCustomizer<? super REQUEST>> contextCustomizers = new ArrayList<ContextCustomizer<? super REQUEST>>();
    private final List<OperationListener> operationListeners = new ArrayList<OperationListener>();
    private final List<OperationMetrics> operationMetrics = new ArrayList<OperationMetrics>();
    @Nullable
    private String instrumentationVersion;
    @Nullable
    private String schemaUrl = null;
    SpanKindExtractor<? super REQUEST> spanKindExtractor = SpanKindExtractor.alwaysInternal();
    SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor = SpanStatusExtractor.getDefault();
    ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.getDefault();
    boolean propagateOperationListenersToOnEnd = false;
    boolean enabled = true;

    InstrumenterBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
        this.spanNameExtractor = spanNameExtractor;
        this.instrumentationVersion = EmbeddedInstrumentationProperties.findVersion(instrumentationName);
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> setInstrumentationVersion(String instrumentationVersion) {
        this.instrumentationVersion = Objects.requireNonNull(instrumentationVersion, "instrumentationVersion");
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> setSchemaUrl(String schemaUrl) {
        this.schemaUrl = Objects.requireNonNull(schemaUrl, "schemaUrl");
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> setSpanStatusExtractor(SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor) {
        this.spanStatusExtractor = Objects.requireNonNull(spanStatusExtractor, "spanStatusExtractor");
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.attributesExtractors.add(Objects.requireNonNull(attributesExtractor, "attributesExtractor"));
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(Iterable<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors) {
        attributesExtractors.forEach(this::addAttributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> addSpanLinksExtractor(SpanLinksExtractor<REQUEST> spanLinksExtractor) {
        this.spanLinksExtractors.add(Objects.requireNonNull(spanLinksExtractor, "spanLinksExtractor"));
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> addContextCustomizer(ContextCustomizer<? super REQUEST> contextCustomizer) {
        this.contextCustomizers.add(Objects.requireNonNull(contextCustomizer, "contextCustomizer"));
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> addOperationListener(OperationListener listener) {
        this.operationListeners.add(Objects.requireNonNull(listener, "operationListener"));
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> addOperationMetrics(OperationMetrics factory) {
        this.operationMetrics.add(Objects.requireNonNull(factory, "operationMetrics"));
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = Objects.requireNonNull(errorCauseExtractor, "errorCauseExtractor");
        return this;
    }

    @CanIgnoreReturnValue
    public InstrumenterBuilder<REQUEST, RESPONSE> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> buildClientInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingToDownstream(Objects.requireNonNull(setter, "setter")), SpanKindExtractor.alwaysClient());
    }

    public Instrumenter<REQUEST, RESPONSE> buildServerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingFromUpstream(Objects.requireNonNull(getter, "getter")), SpanKindExtractor.alwaysServer());
    }

    public Instrumenter<REQUEST, RESPONSE> buildProducerInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingToDownstream(Objects.requireNonNull(setter, "setter")), SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<REQUEST, RESPONSE> buildConsumerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingFromUpstream(Objects.requireNonNull(getter, "getter")), SpanKindExtractor.alwaysConsumer());
    }

    Instrumenter<REQUEST, RESPONSE> buildUpstreamInstrumenter(TextMapGetter<REQUEST> getter, SpanKindExtractor<REQUEST> spanKindExtractor) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingFromUpstream(Objects.requireNonNull(getter, "getter")), spanKindExtractor);
    }

    Instrumenter<REQUEST, RESPONSE> buildDownstreamInstrumenter(TextMapSetter<REQUEST> setter, SpanKindExtractor<REQUEST> spanKindExtractor) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingToDownstream(Objects.requireNonNull(setter, "setter")), spanKindExtractor);
    }

    public Instrumenter<REQUEST, RESPONSE> buildInstrumenter() {
        return this.buildInstrumenter(InstrumenterConstructor.internal(), SpanKindExtractor.alwaysInternal());
    }

    public Instrumenter<REQUEST, RESPONSE> buildInstrumenter(SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        return this.buildInstrumenter(InstrumenterConstructor.internal(), Objects.requireNonNull(spanKindExtractor, "spanKindExtractor"));
    }

    private Instrumenter<REQUEST, RESPONSE> buildInstrumenter(InstrumenterConstructor<REQUEST, RESPONSE> constructor, SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        this.spanKindExtractor = spanKindExtractor;
        return constructor.create(this);
    }

    Tracer buildTracer() {
        String schemaUrl;
        TracerBuilder tracerBuilder = this.openTelemetry.getTracerProvider().tracerBuilder(this.instrumentationName);
        if (this.instrumentationVersion != null) {
            tracerBuilder.setInstrumentationVersion(this.instrumentationVersion);
        }
        if ((schemaUrl = this.getSchemaUrl()) != null) {
            tracerBuilder.setSchemaUrl(schemaUrl);
        }
        return tracerBuilder.build();
    }

    List<OperationListener> buildOperationListeners() {
        String schemaUrl;
        if (this.operationMetrics.isEmpty()) {
            return new ArrayList<OperationListener>(this.operationListeners);
        }
        ArrayList<OperationListener> listeners = new ArrayList<OperationListener>(this.operationListeners.size() + this.operationMetrics.size());
        listeners.addAll(this.operationListeners);
        MeterBuilder meterBuilder = this.openTelemetry.getMeterProvider().meterBuilder(this.instrumentationName);
        if (this.instrumentationVersion != null) {
            meterBuilder.setInstrumentationVersion(this.instrumentationVersion);
        }
        if ((schemaUrl = this.getSchemaUrl()) != null) {
            meterBuilder.setSchemaUrl(schemaUrl);
        }
        Meter meter = meterBuilder.build();
        for (OperationMetrics factory : this.operationMetrics) {
            listeners.add(factory.create(meter));
        }
        return listeners;
    }

    @Nullable
    private String getSchemaUrl() {
        if (this.schemaUrl != null) {
            return this.schemaUrl;
        }
        Set computedSchemaUrls = this.attributesExtractors.stream().filter(SchemaUrlProvider.class::isInstance).map(SchemaUrlProvider.class::cast).flatMap(provider -> {
            String url = provider.internalGetSchemaUrl();
            return url == null ? Stream.of(new String[0]) : Stream.of(url);
        }).collect(Collectors.toSet());
        switch (computedSchemaUrls.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (String)computedSchemaUrls.iterator().next();
            }
        }
        logger.log(Level.WARNING, "Multiple schemaUrls were detected: {0}. The built Instrumenter will have no schemaUrl assigned.", computedSchemaUrls);
        return null;
    }

    SpanSuppressor buildSpanSuppressor() {
        return new SpanSuppressors.ByContextKey(spanSuppressionStrategy.create(this.getSpanKeysFromAttributesExtractors()));
    }

    private Set<SpanKey> getSpanKeysFromAttributesExtractors() {
        return this.attributesExtractors.stream().filter(SpanKeyProvider.class::isInstance).map(SpanKeyProvider.class::cast).flatMap(provider -> {
            SpanKey spanKey = provider.internalGetSpanKey();
            return spanKey == null ? Stream.of(new SpanKey[0]) : Stream.of(spanKey);
        }).collect(Collectors.toSet());
    }

    private void propagateOperationListenersToOnEnd() {
        this.propagateOperationListenersToOnEnd = true;
    }

    static {
        InstrumenterUtil.setInstrumenterBuilderAccess(new InstrumenterBuilderAccess(){

            public <RQ, RS> Instrumenter<RQ, RS> buildUpstreamInstrumenter(InstrumenterBuilder<RQ, RS> builder, TextMapGetter<RQ> getter, SpanKindExtractor<RQ> spanKindExtractor) {
                return builder.buildUpstreamInstrumenter(getter, spanKindExtractor);
            }

            public <RQ, RS> Instrumenter<RQ, RS> buildDownstreamInstrumenter(InstrumenterBuilder<RQ, RS> builder, TextMapSetter<RQ> setter, SpanKindExtractor<RQ> spanKindExtractor) {
                return builder.buildDownstreamInstrumenter(setter, spanKindExtractor);
            }

            public <RQ, RS> void propagateOperationListenersToOnEnd(InstrumenterBuilder<RQ, RS> builder) {
                ((InstrumenterBuilder)builder).propagateOperationListenersToOnEnd();
            }
        });
    }

    private static interface InstrumenterConstructor<RQ, RS> {
        public Instrumenter<RQ, RS> create(InstrumenterBuilder<RQ, RS> var1);

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> internal() {
            return Instrumenter::new;
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingToDownstream(TextMapSetter<RQ> setter) {
            return builder -> new PropagatingToDownstreamInstrumenter(builder, setter);
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingFromUpstream(TextMapGetter<RQ> getter) {
            return builder -> new PropagatingFromUpstreamInstrumenter(builder, getter);
        }
    }
}

