/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.ExportableColumnHelper;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.TableGeneratorLogger;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TableStructure
implements DatabaseStructure {
    private final QualifiedName logicalQualifiedTableName;
    private final Identifier logicalValueColumnNameIdentifier;
    private final int initialValue;
    private final int incrementSize;
    private final Class<?> numberType;
    private final String options;
    private final String contributor;
    private QualifiedName physicalTableName;
    private String valueColumnNameText;
    private String selectQuery;
    private String updateQuery;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(String contributor, QualifiedName qualifiedTableName, Identifier valueColumnNameIdentifier, int initialValue, int incrementSize, Class<?> numberType) {
        this(contributor, qualifiedTableName, valueColumnNameIdentifier, initialValue, incrementSize, null, numberType);
    }

    public TableStructure(String contributor, QualifiedName qualifiedTableName, Identifier valueColumnNameIdentifier, int initialValue, int incrementSize, String options, Class<?> numberType) {
        this.contributor = contributor;
        this.logicalQualifiedTableName = qualifiedTableName;
        this.logicalValueColumnNameIdentifier = valueColumnNameIdentifier;
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
        this.options = options;
        this.numberType = numberType;
    }

    @Override
    public QualifiedName getPhysicalName() {
        return this.physicalTableName;
    }

    public Identifier getLogicalValueColumnNameIdentifier() {
        return this.logicalValueColumnNameIdentifier;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public int getTimesAccessed() {
        return this.accessCounter;
    }

    @Override
    @Deprecated
    public String[] getAllSqlForTests() {
        return new String[]{this.selectQuery, this.updateQuery};
    }

    @Override
    @Deprecated
    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    private IntegralDataTypeHolder makeValue() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.numberType);
    }

    @Override
    public AccessCallback buildCallback(final SharedSessionContractImplementor session) {
        if (this.selectQuery == null || this.updateQuery == null) {
            throw new AssertionFailure("SequenceStyleGenerator's TableStructure was not properly initialized");
        }
        final SessionEventListenerManager statsCollector = session.getEventListenerManager();
        final SqlStatementLogger statementLogger = session.getFactory().getJdbcServices().getSqlStatementLogger();
        return new AccessCallback(){

            @Override
            public IntegralDataTypeHolder getNextValue() {
                return session.getTransactionCoordinator().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

                    @Override
                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int rows;
                        IntegralDataTypeHolder value = TableStructure.this.makeValue();
                        do {
                            try (PreparedStatement selectStatement = TableStructure.this.prepareStatement(connection, TableStructure.this.selectQuery, statementLogger, statsCollector, session);){
                                ResultSet selectRS = TableStructure.this.executeQuery(selectStatement, statsCollector, TableStructure.this.selectQuery, session);
                                if (!selectRS.next()) {
                                    throw new IdentifierGenerationException("Could not read a hi value, populate the table: " + String.valueOf(TableStructure.this.physicalTableName));
                                }
                                value.initialize(selectRS, 1L);
                                selectRS.close();
                            }
                            catch (SQLException sqle) {
                                TableGeneratorLogger.TABLE_GENERATOR_MESSAGE_LOGGER.unableToReadHiValue(TableStructure.this.physicalTableName.render(), sqle);
                                throw sqle;
                            }
                            try (PreparedStatement updatePS = TableStructure.this.prepareStatement(connection, TableStructure.this.updateQuery, statementLogger, statsCollector, session);){
                                int increment = TableStructure.this.applyIncrementSizeToSourceValues ? TableStructure.this.incrementSize : 1;
                                IntegralDataTypeHolder updateValue = value.copy().add(increment);
                                updateValue.bind(updatePS, 1);
                                value.bind(updatePS, 2);
                                rows = TableStructure.this.executeUpdate(updatePS, statsCollector, TableStructure.this.updateQuery, session);
                            }
                            catch (SQLException e) {
                                TableGeneratorLogger.TABLE_GENERATOR_MESSAGE_LOGGER.unableToUpdateHiValue(TableStructure.this.physicalTableName.render(), e);
                                throw e;
                            }
                        } while (rows == 0);
                        ++TableStructure.this.accessCounter;
                        return value;
                    }
                }, true);
            }

            @Override
            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(Connection connection, String sql, SqlStatementLogger logger2, SessionEventListenerManager statsCollector, SharedSessionContractImplementor session) throws SQLException {
        logger2.logStatement(sql, FormatStyle.BASIC.getFormatter());
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent creationEvent = eventMonitor.beginJdbcPreparedStatementCreationEvent();
        StatisticsImplementor stats = session.getFactory().getStatistics();
        try {
            statsCollector.jdbcPrepareStatementStart();
            if (stats != null && stats.isStatisticsEnabled()) {
                stats.prepareStatement();
            }
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement;
        }
        finally {
            eventMonitor.completeJdbcPreparedStatementCreationEvent(creationEvent, sql);
            statsCollector.jdbcPrepareStatementEnd();
            if (stats != null && stats.isStatisticsEnabled()) {
                stats.closeStatement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(PreparedStatement ps, SessionEventListenerManager statsCollector, String sql, SharedSessionContractImplementor session) throws SQLException {
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent executionEvent = eventMonitor.beginJdbcPreparedStatementExecutionEvent();
        try {
            statsCollector.jdbcExecuteStatementStart();
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            eventMonitor.completeJdbcPreparedStatementExecutionEvent(executionEvent, sql);
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(PreparedStatement ps, SessionEventListenerManager statsCollector, String sql, SharedSessionContractImplementor session) throws SQLException {
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent executionEvent = eventMonitor.beginJdbcPreparedStatementExecutionEvent();
        try {
            statsCollector.jdbcExecuteStatementStart();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        finally {
            eventMonitor.completeJdbcPreparedStatementExecutionEvent(executionEvent, sql);
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    @Override
    public boolean isPhysicalSequence() {
        return false;
    }

    @Override
    public void registerExportables(Database database) {
        boolean tableCreated;
        Namespace namespace = database.locateNamespace(this.logicalQualifiedTableName.getCatalogName(), this.logicalQualifiedTableName.getSchemaName());
        Table table = namespace.locateTable(this.logicalQualifiedTableName.getObjectName());
        if (table == null) {
            table = namespace.createTable(this.logicalQualifiedTableName.getObjectName(), identifier -> new Table(this.contributor, namespace, (Identifier)identifier, false));
            tableCreated = true;
        } else {
            tableCreated = false;
        }
        this.physicalTableName = table.getQualifiedTableName();
        this.valueColumnNameText = this.logicalValueColumnNameIdentifier.render(database.getJdbcEnvironment().getDialect());
        if (tableCreated) {
            TypeConfiguration typeConfiguration = database.getTypeConfiguration();
            BasicType<Long> type = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.LONG);
            Column valueColumn = ExportableColumnHelper.column(database, table, this.valueColumnNameText, type, typeConfiguration.getDdlTypeRegistry().getTypeName(type.getJdbcType().getDdlTypeCode(), database.getDialect()));
            table.addColumn(valueColumn);
            table.setOptions(this.options);
            table.addInitCommand(context -> new InitCommand("insert into " + context.format(this.physicalTableName) + " ( " + this.valueColumnNameText + " ) values ( " + this.initialValue + " )"));
        }
    }

    @Override
    public void initialize(SqlStringGenerationContext context) {
        Dialect dialect = context.getDialect();
        String formattedPhysicalTableName = context.format(this.physicalTableName);
        String lockedTable = dialect.appendLockHint(new LockOptions(LockMode.PESSIMISTIC_WRITE), formattedPhysicalTableName) + dialect.getForUpdateString();
        this.selectQuery = "select " + this.valueColumnNameText + " as id_val from " + lockedTable;
        this.updateQuery = "update " + formattedPhysicalTableName + " set " + this.valueColumnNameText + "= ? where " + this.valueColumnNameText + "=?";
    }
}

