/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Segments structures in images based on image features derived from
pseudo-canny-edges.


IMPORTANT
The SegmentationLevelSetImageFilter class and the CannySegmentationLevelSetFunction class contain additional information necessary to the full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. It constructs a
speed function which is designed to lock onto edges as detected by a
Canny filter.

The CannySegmentationLevelSetImageFilter can be a tool for refining an existing segmentation, or it can be
used to try to segment a region by itself. Like all other level-set
based segmentation filters (see SegmentationLevelSetImageFilter ), it works by first constructing a scalar speed term and a vector
advection field based on edge features in the image. The level set
front is then moved according to these two terms with the addition of
a third curvature term to control the smoothness of the solution.

The speed term is constructed as the Danielsson distance transform of
the Canny edge image, as calculated by the CannyEdgeDetectionImageFilter . This scalar speed can be tuned in and out of the final evolution
equation by setting the PropagationScaling parameter (a value of 0
removes the speed term).

The advection field term is constructed by minimizing Danielsson
distance squared. i.e. $ \\mbox{min} \\int D^2 \\Rightarrow D \\nabla D $ . This term moves the level set down the gradient of the distance
transform.

In practice, you may set the speed (propagation) term to zero if your
initialization is already close to the edge you are interested in. If
you are trying to segment a region by seeding with a small surface
(blob, sphere) then you will likely want to add speed (propagation) to
the equation so that the levelsets can expand along zero gradients.
The relative influence of these two terms are controlled by the
SetPropagationScaling and SetAdvectionScaling parameters.
INPUTS
This filter requires two inputs. The first input is a seed image. This
seed image must contain an isosurface that you want to use as the seed
for your segmentation. It can be a binary, graylevel, or floating
point image. The only requirement is that it contain a closed
isosurface that you will identify as the seed by setting the
IsosurfaceValue parameter of the filter. For a binary image you will
want to set your isosurface value halfway between your on and off
values (i.e. for 0's and 1's, use an isosurface value of 0.5).

The second input is the feature image. This is the image from which
the speed function will be calculated. For most applications, this is
the image that you want to segment. The desired isosurface in your
seed image should lie within the region of your feature image that you
are trying to segment.

See SegmentationLevelSetImageFilter for more information on Inputs.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Positive
*values in the output image are inside the segmented region and
negative *values in the image are outside of the inside region. The
zero crossings of *the image correspond to the position of the level
set front.

See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
PARAMETERS
There are five parameters important for controlling the behavior of
this filter.

(1) Threshold. Sets the thresholding value of the Canny edge
detection. See CannyEdgeDetectionImageFilter for more information.

(2) Variance. Controls the smoothing parameter of the gaussian
filtering done during Canny edge detection.

(3) CurvatureScaling. Controls the degree to which curvature
influences the evolution of the level set. Higher values relative to
Propagation and Advection scalings will yield a smoother surface.

(4) PropagationScaling. Scales the propagation (speed) term of the
level set equation. Set this term to zero to allow the level set to
flow only down the gradient of the distance transform.

(5) AdvectionScaling. Scales influence of the advection field relative
to curvature and propagation terms.

See:
 SegmentationLevelSetImageFilter

 CannySegmentationLevelSetFunction ,

 SparseFieldLevelSetImageFilter

 itk::simple::CannySegmentationLevelSet for the procedural interface

 itk::CannySegmentationLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCannySegmentationLevelSetImageFilter.h
*/
public class CannySegmentationLevelSetImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CannySegmentationLevelSetImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CannySegmentationLevelSetImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CannySegmentationLevelSetImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CannySegmentationLevelSetImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CannySegmentationLevelSetImageFilter::~CannySegmentationLevelSetImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CannySegmentationLevelSetImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CannySegmentationLevelSetImageFilter::CannySegmentationLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CannySegmentationLevelSetImageFilter() {
    this(SimpleITKJNI.new_CannySegmentationLevelSetImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetThreshold(double Threshold)

Set the Threshold parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.

*/
public  void setThreshold(double Threshold) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setThreshold(swigCPtr, this, Threshold);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetThreshold() const

Set the Threshold parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.

*/
public  double getThreshold() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetVariance(double Variance)

Set the Variance parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.

*/
public  void setVariance(double Variance) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setVariance(swigCPtr, this, Variance);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetVariance() const

Set the Variance parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.

*/
public  double getVariance() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getVariance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetPropagationScaling(double PropagationScaling)
*/
public  void setPropagationScaling(double PropagationScaling) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setPropagationScaling(swigCPtr, this, PropagationScaling);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetPropagationScaling() const
*/
public  double getPropagationScaling() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getPropagationScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetCurvatureScaling(double CurvatureScaling)
*/
public  void setCurvatureScaling(double CurvatureScaling) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setCurvatureScaling(swigCPtr, this, CurvatureScaling);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetCurvatureScaling() const
*/
public  double getCurvatureScaling() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getCurvatureScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetAdvectionScaling(double AdvectionScaling)
*/
public  void setAdvectionScaling(double AdvectionScaling) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setAdvectionScaling(swigCPtr, this, AdvectionScaling);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetAdvectionScaling() const
*/
public  double getAdvectionScaling() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getAdvectionScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::CannySegmentationLevelSetImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetReverseExpansionDirection(bool ReverseExpansionDirection)
*/
public  void setReverseExpansionDirection(boolean ReverseExpansionDirection) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setReverseExpansionDirection(swigCPtr, this, ReverseExpansionDirection);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::ReverseExpansionDirectionOn()

Set the value of ReverseExpansionDirection to true or false
respectfully.

*/
public  void reverseExpansionDirectionOn() {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_reverseExpansionDirectionOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::ReverseExpansionDirectionOff()
*/
public  void reverseExpansionDirectionOff() {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_reverseExpansionDirectionOff(swigCPtr, this);
  }

  /**
bool itk::simple::CannySegmentationLevelSetImageFilter::GetReverseExpansionDirection() const
*/
public  boolean getReverseExpansionDirection() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getReverseExpansionDirection(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CannySegmentationLevelSetImageFilter::SetIsoSurfaceValue(double IsoSurfaceValue)
*/
public  void setIsoSurfaceValue(double IsoSurfaceValue) {
    SimpleITKJNI.CannySegmentationLevelSetImageFilter_setIsoSurfaceValue(swigCPtr, this, IsoSurfaceValue);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetIsoSurfaceValue() const
*/
public  double getIsoSurfaceValue() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getIsoSurfaceValue(swigCPtr, this);
  }

  /**
uint32_t itk::simple::CannySegmentationLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::CannySegmentationLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getRMSChange(swigCPtr, this);
  }

  /**
Image itk::simple::CannySegmentationLevelSetImageFilter::GetCannyImage() const

Get the Canny image that was used to create the speed and advection
images

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  Image getCannyImage() {
    return new Image(SimpleITKJNI.CannySegmentationLevelSetImageFilter_getCannyImage(swigCPtr, this), true);
  }

  /**
std::string itk::simple::CannySegmentationLevelSetImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CannySegmentationLevelSetImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CannySegmentationLevelSetImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CannySegmentationLevelSetImageFilter::Execute(Image &amp;&amp;initialImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.CannySegmentationLevelSetImageFilter_execute(swigCPtr, this, Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

}
