/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u000fH\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/diagnostics/RenderedDiagnostic;", "D", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "diagnostic", "renderer", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getRenderer", "()Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "text", "", "getText", "()Ljava/lang/String;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "toString", "frontend"})
public final class RenderedDiagnostic<D extends Diagnostic> {
    @NotNull
    private final D diagnostic;
    @NotNull
    private final DiagnosticRenderer<D> renderer;
    @NotNull
    private final String text;

    public RenderedDiagnostic(@NotNull D diagnostic, @NotNull DiagnosticRenderer<? super D> renderer) {
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.diagnostic = diagnostic;
        this.renderer = renderer;
        this.text = this.renderer.render((UnboundDiagnostic)this.diagnostic);
    }

    @NotNull
    public final D getDiagnostic() {
        return this.diagnostic;
    }

    @NotNull
    public final DiagnosticRenderer<D> getRenderer() {
        return this.renderer;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final DiagnosticFactory<?> getFactory() {
        return ((UnboundDiagnostic)this.diagnostic).getFactory();
    }

    @NotNull
    public String toString() {
        return this.text;
    }
}

