#############################################################################
##
#W    matgrp3.gi                                                Karel Dekimpe
#W                                                               Bettina Eick
##
##    This file contains the 3-dimensional almost crystallographic groups
##    as integral matrix groups. There are 17 types of groups.
##

ACDim3Nr01 := function ( k1 )
local a, b, c;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
return Group( [a , b, c] , IdentityMat(4) );
end;
 
ACDim3Nr02 := function ( k1, k2, k3, k4)
local a, b, c, alfa;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, k3, k4/2], [0, -1, 0, 0], [0, 0, -1, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa] , IdentityMat(4) );
end;
 
ACDim3Nr03 := function ( k1, k2 )
local a, b, c, alfa;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[-1, -k2, 0, 0], [0, 1, 0, 0], [0, 0, -1, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa] , IdentityMat(4) );
end;
 
ACDim3Nr04 := function ( k1, k2 )
local a, b, c, alfa;
a:=[[1, 0, -k1, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[-1, 2*k2, k1/2, 0], [0, 1, 0, 1/2], [0, 0, -1, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa] , IdentityMat(4) );
end;
 
ACDim3Nr05 := function ( k1, k2 )
local a, b, c, alfa;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[-1, -k2, -k2, 0], [0, 0, 1, 0], [0, 1, 0, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa ] , IdentityMat(4) );
end;
 
ACDim3Nr06 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, k3, k4/2], [0, -1, 0, 0], [0, 0, -1, 0], [0, 0, 0, 1]];
beta:=[[-1, -k2, 0, 0], [0, 1, 0, 0], [0, 0, -1, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr07 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, -2*(k3 + k4), k3/2], [0, -1, 0, 0], [0, 0, -1, 0], [0, 0, 0, 1]];
beta:=[[-1, k1/2 - k2, 0, 0], [0, 1, 0, 0], [0, 0, -1, 1/2], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr08 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k1 + 2*k3, -k1 + 2*k2 - 2*k3, k4/2], [0, -1, 0, 0], [0, 0, -1, 0], 
 [0, 0, 0, 1]];
beta:=[[-1, -k1/2 - 2*k3, k1/2, 0], [0, 1, 0, 1/2], [0, 0, -1, 1/2], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr09 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, -k2 + 2*k3, k4/2], [0, -1, 0, 0], [0, 0, -1, 0], [0, 0, 0, 1]];
beta:=[[-1, -k3, -k3, 0], [0, 0, 1, 0], [0, 1, 0, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr10 := function ( k1, k2, k3, k4)
local a, b, c, alfa;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, k3, k4/4], [0, 0, -1, 0], [0, 1, 0, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa] , IdentityMat(4) );
end;
 
ACDim3Nr11 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, k3, k4/4], [0, 0, -1, 0], [0, 1, 0, 0], [0, 0, 0, 1]];
beta:=[[-1, -k2 - k3, 0,  0], [0, 1, 0, 0], [0, 0, -1, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr12 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, k1 - k2 - 2*k3, k4/4], [0, 0, -1, 0], [0, 1, 0, 0], [0, 0, 0, 1]];
beta:=[[-1, -k1/2 + 2*k3, k1/2, 0], [0, 1, 0, 1/2], [0, 0, -1, 1/2], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr13 := function ( k1, k2, k3, k4)
local a, b, c, alfa;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, -k1/2 + k3, k4/3], [0, 0, -1, 0], [0, 1, -1, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa] , IdentityMat(4) );
end;
 
ACDim3Nr14 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k2, -k1/2 + k3, k4/3], [0, 0, -1, 0], [0, 1, -1, 0], [0, 0, 0, 1]];
beta:=[[-1, -k2 , k2 , 0], [0, 0, -1, 0], [0, -1, 0, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr15 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, k1 - 2*k3 + 3*k2, -k1/2 + k3, k4/3], [0, 0, -1, 0], [0, 1, -1, 0], 
 [0, 0, 0, 1]];
beta:=[[-1, -k2, -k2,  0], [0, 0, 1, 0], [0, 1, 0, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
ACDim3Nr16 := function ( k1, k2, k3, k4)
local a, b, c, alfa;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, -k1/2 + k2, k3, k4/6], [0, 1, -1, 0], [0, 1, 0, 0], 
 [0, 0, 0, 1]];
return Group( [a , b, c, alfa] , IdentityMat(4) );
end;
 
ACDim3Nr17 := function ( k1, k2, k3, k4)
local a, b, c, alfa, beta;
a:=[[1, 0, -k1/2, 0], [0, 1, 0, 1], [0, 0, 1, 0], [0, 0, 0, 1]];
b:=[[1, k1/2, 0, 0], [0, 1, 0, 0], [0, 0, 1, 1], [0, 0, 0, 1]];
c:=[[1, 0, 0, 1], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]];
alfa:=[[1, -k1/2 + k2, k3, k4/6], [0, 1, -1, 0], [0, 1, 0, 0], 
 [0, 0, 0, 1]];
beta:=[[-1, -k3, -k3, 0], [0, 0, 1, 0], [0, 1, 0, 0], [0, 0, 0, 1]];
return Group( [a , b, c, alfa, beta] , IdentityMat(4) );
end;
 
#############################################################################
##
#V ACDim3Funcs
#V ACDim3Param
##
ACDim3Funcs := [ ACDim3Nr01, ACDim3Nr02, ACDim3Nr03, ACDim3Nr04, ACDim3Nr05, 
ACDim3Nr06, ACDim3Nr07, ACDim3Nr08, ACDim3Nr09, ACDim3Nr10, ACDim3Nr11, 
ACDim3Nr12, ACDim3Nr13, ACDim3Nr14, ACDim3Nr15, ACDim3Nr16, ACDim3Nr17 ];
MakeReadOnlyGlobal( "ACDim3Funcs" );

ACDim3Param := [ 1,4,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4 ]; 
MakeReadOnlyGlobal( "ACDim3Param" );



