/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryUi;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class DiscoveryWizard
extends Wizard {
    private final Catalog catalog;
    private CatalogPage catalogPage;
    private final CatalogConfiguration configuration;

    public DiscoveryWizard(Catalog catalog, CatalogConfiguration configuration) {
        Assert.isNotNull((Object)catalog);
        Assert.isNotNull((Object)configuration);
        this.catalog = catalog;
        this.configuration = configuration;
        this.setWindowTitle(Messages.DiscoveryWizard_Install_Window_Title);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(DiscoveryImages.BANNER_DISOVERY);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getCatalogPage());
    }

    protected CatalogPage doCreateCatalogPage() {
        return new CatalogPage(this.getCatalog());
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public CatalogPage getCatalogPage() {
        if (this.catalogPage == null) {
            this.catalogPage = this.doCreateCatalogPage();
        }
        return this.catalogPage;
    }

    public CatalogConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean performFinish() {
        return DiscoveryUi.install(this.catalogPage.getInstallableConnectors(), (IRunnableContext)this.getContainer());
    }
}

