/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCTransaction;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.backup.JDBCDatabaseBackupDescriptor;
import org.jkiss.dbeaver.model.sql.backup.JDBCDatabaseBackupRegistry;
import org.jkiss.dbeaver.model.sql.schema.SQLInitialSchemaFiller;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaConnectionProvider;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaScriptSource;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaVersionManager;
import org.jkiss.dbeaver.model.sql.translate.SQLQueryTranslator;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public final class SQLSchemaManager {
    private static final Log log = Log.getLog(SQLSchemaManager.class);
    @NotNull
    private final String schemaId;
    @NotNull
    private final SQLSchemaScriptSource scriptSource;
    @NotNull
    private final SQLSchemaConnectionProvider connectionProvider;
    @NotNull
    private final SQLSchemaVersionManager versionManager;
    @NotNull
    private final SQLDialect targetDatabaseDialect;
    private final int schemaVersionActual;
    private final int schemaVersionObsolete;
    @NotNull
    private final InternalDatabaseConfig databaseConfig;
    @Nullable
    private final SQLInitialSchemaFiller sqlInitialSchemaFiller;

    public SQLSchemaManager(@NotNull String schemaId, @NotNull SQLSchemaScriptSource scriptSource, @NotNull SQLSchemaConnectionProvider connectionProvider, @NotNull SQLSchemaVersionManager versionManager, @NotNull SQLDialect targetDatabaseDialect, int schemaVersionActual, int schemaVersionObsolete, @NotNull InternalDatabaseConfig databaseConfig, @Nullable SQLInitialSchemaFiller sqlInitialSchemaFiller) {
        this.schemaId = schemaId;
        this.scriptSource = scriptSource;
        this.connectionProvider = connectionProvider;
        this.versionManager = versionManager;
        this.targetDatabaseDialect = targetDatabaseDialect;
        this.schemaVersionActual = schemaVersionActual;
        this.schemaVersionObsolete = schemaVersionObsolete;
        this.databaseConfig = databaseConfig;
        this.sqlInitialSchemaFiller = sqlInitialSchemaFiller;
    }

    public void updateSchema(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            Connection dbCon = this.connectionProvider.getDatabaseConnection(monitor);
            try (JDBCTransaction txn = new JDBCTransaction(dbCon);){
                try {
                    int currentSchemaVersion = this.versionManager.getCurrentSchemaVersion(monitor, dbCon, this.databaseConfig.getSchema());
                    txn.rollback();
                    if (currentSchemaVersion < 0) {
                        this.createNewSchema(monitor, dbCon);
                        this.versionManager.updateCurrentSchemaVersion(monitor, dbCon, this.databaseConfig.getSchema(), this.versionManager.getLatestSchemaVersion());
                    } else if (this.schemaVersionObsolete > 0 && currentSchemaVersion < this.schemaVersionObsolete) {
                        this.dropSchema(monitor, dbCon);
                        this.createNewSchema(monitor, dbCon);
                        this.versionManager.updateCurrentSchemaVersion(monitor, dbCon, this.databaseConfig.getSchema(), this.versionManager.getLatestSchemaVersion());
                    } else if (this.schemaVersionActual > currentSchemaVersion) {
                        this.doBackupDatabase(dbCon, currentSchemaVersion);
                        this.upgradeSchemaVersion(monitor, dbCon, txn, currentSchemaVersion);
                    }
                    txn.commit();
                }
                catch (Exception e) {
                    txn.rollback();
                    log.warn((Object)(this.schemaId + " migration has been rolled back"));
                    throw e;
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new DBException("Error updating " + this.schemaId + " schema version", (Throwable)e);
        }
    }

    private void doBackupDatabase(@NotNull Connection dbCon, int currentSchemaVersion) throws IOException, DBException {
        JDBCDatabaseBackupDescriptor descriptor;
        if (this.databaseConfig.isBackupEnabled() && (descriptor = JDBCDatabaseBackupRegistry.getInstance().getCurrentDescriptor(this.targetDatabaseDialect)) != null) {
            try {
                descriptor.getInstance().doBackup(dbCon, currentSchemaVersion, this.databaseConfig);
                log.info((Object)"Starting backup execution");
            }
            catch (DBException e) {
                DBPApplication application = DBWorkbench.getPlatform().getApplication();
                if (application.isHeadlessMode() && application.isCommunity()) {
                    log.warn((Object)("Database backup failed: " + e.getMessage()));
                    return;
                }
                throw new DBException("Internal database backup has failed", (Throwable)e);
            }
        }
    }

    private void upgradeSchemaVersion(@NotNull DBRProgressMonitor monitor, @NotNull Connection connection, @NotNull JDBCTransaction txn, int currentSchemaVersion) throws IOException, DBException, SQLException {
        for (int curVer = currentSchemaVersion; curVer < this.schemaVersionActual; ++curVer) {
            int updateToVer = curVer + 1;
            Reader ddlStream = this.scriptSource.openSchemaUpdateScript(monitor, updateToVer, this.targetDatabaseDialect.getDialectId());
            if (ddlStream == null) continue;
            log.debug((Object)("Update schema " + this.schemaId + " version from " + curVer + " to " + updateToVer));
            try {
                this.executeScript(monitor, connection, ddlStream, true);
                this.versionManager.updateCurrentSchemaVersion(monitor, connection, this.databaseConfig.getSchema(), updateToVer);
                txn.commit();
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Error updating " + this.schemaId + " schema version from " + curVer + " to " + updateToVer), (Throwable)e);
                throw e;
            }
            finally {
                ContentUtils.close((Closeable)ddlStream);
            }
        }
    }

    private void createNewSchema(@NotNull DBRProgressMonitor monitor, @NotNull Connection connection) throws IOException, DBException, SQLException {
        log.debug((Object)("Create new schema " + this.schemaId));
        try (Reader ddlStream = this.scriptSource.openSchemaCreateScript(monitor, this.targetDatabaseDialect.getDialectId());){
            this.executeScript(monitor, connection, ddlStream, false);
        }
        if (this.sqlInitialSchemaFiller != null) {
            this.sqlInitialSchemaFiller.fillInitialSchemaData(monitor, connection);
        }
    }

    private void dropSchema(@NotNull DBRProgressMonitor monitor, @NotNull Connection connection) throws DBException, SQLException, IOException {
        log.debug((Object)("Drop schema " + this.schemaId));
        this.executeScript(monitor, connection, new StringReader("DROP ALL OBJECTS"), true);
    }

    private void executeScript(@NotNull DBRProgressMonitor monitor, @NotNull Connection connection, @NotNull Reader ddlStream, boolean logQueries) throws SQLException, IOException, DBException {
        String[] ddl;
        String ddlText = CommonUtils.normalizeTableNames((String)IOUtils.readToString((Reader)ddlStream), (String)this.databaseConfig.getSchema());
        DBPPreferenceStore prefStore = SQLQueryTranslator.getDefaultPreferenceStore();
        BasicSQLDialect sourceDialect = new BasicSQLDialect(this){};
        ddlText = SQLQueryTranslator.translateScript((SQLDialect)sourceDialect, (SQLDialect)this.targetDatabaseDialect, (DBPPreferenceStore)prefStore, (String)ddlText);
        for (String line : ddl = ddlText.split(";")) {
            if ((line = line.trim()).isEmpty()) continue;
            if (logQueries) {
                log.debug((Object)("Process [" + line + "]"));
            }
            try (Statement dbStat = connection.createStatement();){
                try {
                    log.debug((Object)("Execute migration query: " + line));
                    dbStat.execute(line);
                }
                catch (SQLException e) {
                    log.error((Object)"Error during sql migration", (Throwable)e);
                    log.debug((Object)"Trying to apply the migration again");
                    dbStat.execute(line);
                    log.debug((Object)"The second schema migration attempt was successful");
                }
            }
        }
    }
}

